package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.facade.MissionFeignService;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2018/2/23.
 */
@Service
@Slf4j
public class MissionIntegrationService {

    @Autowired
    private MissionFeignService missionFeignService;

    public void completeTask(Long userId, TaskEnum taskTypeEnum, String relationId) {
        log.debug("用户[{}]远程完成任务调用接口", userId);
        missionFeignService.completeTask(userId, taskTypeEnum.name(), relationId).getBody();
    }
}
