package com.bxm.localnews.user.integration;

import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.facade.SmsFeignService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsIntegrationService {

    @Autowired
    private SmsFeignService smsFeignService;

    public Boolean verifySmsCodeByType(Byte type, String phoneNo, String code) {
        return smsFeignService.verifySmsCodeByType(type, phoneNo, code).getBody();
    }

    public SendSmsResult sendSmsByVCodeTemplate(SmsSupplyDTO smsSupplyDTO) {
        return smsFeignService.sendSmsByVCodeTemplate(smsSupplyDTO).getBody();
    }

}
