package com.bxm.localnews.user.vo;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.newidea.component.vo.BaseBean;
import com.fasterxml.jackson.annotation.JsonIgnore;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
public class DailyTask extends BaseBean {

    //新手任务
    public static final Byte NEWBIEW_TASK = 10;

    //日常任务
    public static final Byte DAILY_TASK = 20;

    public static final Byte ADVERT_TASK = 30;

    @ApiModelProperty("任务ID")
    private Long id;

    @ApiModelProperty("类型 10:新手任务 20:日常任务 30:广告任务")
    private Byte type;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("任务名称")
    private String name;

    @ApiModelProperty("任务显示图标")
    private String headImg;

    @ApiModelProperty("热度表示,10:热度低, 20:热度高")
    private Byte hotState;

    @ApiModelProperty("动作描述")
    private String action;

    @ApiModelProperty(value = "任务等级（排序规则）", hidden = true)
    private Integer level;

    @ApiModelProperty("任务描述")
    private String prompt;

    @ApiModelProperty(value = "任务完成给与的奖励", hidden = true)
    private BigDecimal reward;

    @ApiModelProperty("钱币类型：10:金币 20:零钱")
    private Byte rewardType;

    @ApiModelProperty(hidden = true)
    private BigDecimal rewardLimit;

    @ApiModelProperty("奖励描述")
    private String remark;

    @ApiModelProperty(hidden = true)
    private Date createTime;

    @ApiModelProperty(hidden = true)
    private Date updateTime;

    @ApiModelProperty(value = "是否完成", hidden = false)
    private Boolean isCompleted;

    @ApiModelProperty(value = "完成了几次", hidden = false)
    private Integer completedNum;

    @ApiModelProperty(value = "总数", hidden = false)
    private Integer totalNum;

    @JsonIgnore
    private Integer number;

    @ApiModelProperty(value = "跳转地址")
    private String address;

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Integer getTotalNum() {
        return totalNum;
    }

    public void setTotalNum(Integer totalNum) {
        this.totalNum = totalNum;
    }

    public Boolean getCompleted() {
        return isCompleted;
    }

    public void setCompleted(Boolean completed) {
        isCompleted = completed;
    }

    public Integer getCompletedNum() {
        return completedNum;
    }

    public void setCompletedNum(Integer completedNum) {
        this.completedNum = completedNum;
    }

    public String getHeadImg() {
        return this.headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public Byte getHotState() {
        return this.hotState;
    }

    public void setHotState(Byte hotState) {
        this.hotState = hotState;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action == null ? null : action.trim();
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt == null ? null : prompt.trim();
    }

    public BigDecimal getReward() {
        return this.reward;
    }

    public void setReward(BigDecimal reward) {
        this.reward = reward;
    }

    public Byte getRewardType() {
        return this.rewardType;
    }

    public void setRewardType(Byte rewardType) {
        this.rewardType = rewardType;
    }

    public BigDecimal getRewardLimit() {
        return this.rewardLimit;
    }

    public void setRewardLimit(BigDecimal rewardLimit) {
        this.rewardLimit = rewardLimit;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}