package com.bxm.localnews.user.facade;

import java.math.BigDecimal;

import com.bxm.localnews.user.facade.fallback.BizLogFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 业务日志记录服务接口
 */
@FeignClient(value = "localnews", fallbackFactory = BizLogFallbackFactory.class)
public interface BizLogFeignService {

    @PostMapping("facade/biz/log/register")
    void newUser(@RequestParam("userId") Long userId, @RequestParam("channel") String channel,
                 @RequestParam("token") String token, @RequestParam("amount") BigDecimal amount,
                 @RequestParam("registerChannel") String registerChannel,
                 @RequestParam("rid") String rid, @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/login")
    void login(@RequestParam("userId") Long userId, @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/changeGender")
    void changeGender(@RequestParam("userId") Long userId, @RequestParam("sex") int sex,
                      @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/changeArea")
    void changeArea(@RequestParam("userId") Long userId, @RequestParam("areaCode") String areaCode,
                    @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/inviteSuccessed")
    void inviteSuccessed(@RequestParam("userId") Long userId, @RequestParam("invitedUserId") Long invitedUserId,
                         @RequestParam(value = "platform", required = false) Integer platform);
}
