package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationDetailDTO;
import com.bxm.localnews.user.facade.fallback.LocationFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/1 14:09
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = LocationFallbackFactory.class)
public interface LocationFeignService {

    @GetMapping("")
    ResponseEntity<LocationDTO> getLocationByCode(@RequestParam("code") String code);

    @GetMapping("")
    ResponseEntity<LocationDetailDTO> getLocationDetailByCode(@RequestParam("code") String code);

    @GetMapping("/facade/location/info")
    ResponseEntity<LocationDTO> getLocationByGeocode(@RequestParam("code") String code);
}
