package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.facade.fallback.VipFallBackFactory;
import com.bxm.localnews.user.param.RecordWechatParam;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/2/28 18:17
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = VipFallBackFactory.class)
public interface VipFeignService {

    @PostMapping("/facade/activity/vip/save")
    ResponseEntity saveVipViewRecord(@RequestParam("userId") Long userId,
                                     @RequestParam("unionId") String unionId,
                                     @RequestParam("platform") Integer platform);

    @GetMapping("/facade/activity/vip/invitenum")
    ResponseEntity<Integer> countVipByUser(@RequestParam("userId") Long userId);

    @PostMapping("/facade/activity/vip/save/view/record")
    ResponseEntity saveTempViewRecord(@RequestBody RecordWechatParam recordWechatParam);
}
