package com.bxm.localnews.user.facade;

import java.math.BigDecimal;

import com.bxm.localnews.user.facade.fallback.WithdrawFallbackFactory;
import com.bxm.newidea.component.vo.Message;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/5/29 15:56
 * @desc
 */

@FeignClient(value = "localnews", fallbackFactory = WithdrawFallbackFactory.class)
public interface WithdrawFeignService {

    @PostMapping("/facade/withdraw/manage/applet")
    ResponseEntity<Message> appletWithdraw(@RequestParam("userId") Long userId,
                                           @RequestParam("openId") String openId,
                                           @RequestParam("amount") BigDecimal amount,
                                           @RequestParam("devcId") String devcId,
                                           @RequestParam("ip") String ip);
}
