package com.bxm.localnews.user.facade.fallback;

import java.math.BigDecimal;

import com.bxm.localnews.user.facade.BizLogFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 17:49
 * @desc
 */
@Component
@Slf4j
public class BizLogFallbackFactory implements FallbackFactory<BizLogFeignService> {
    @Override
    public BizLogFeignService create(Throwable throwable) {
        return new BizLogFeignService() {

            @Override
            public void newUser(Long userId, String channel, String token, BigDecimal amount, String registerChannel, String rid, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void login(Long userId, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void changeGender(Long userId, int sex, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void changeArea(Long userId, String areaCode, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void inviteSuccessed(Long userId, Long invitedUserId, Integer platform) {
                log.error(throwable.getMessage(), throwable);
            }
        };
    }
}

