package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.user.facade.InviteRelationFeignService;
import com.bxm.localnews.user.vo.ApprenticeInfoVo;
import com.bxm.localnews.user.vo.ShareMessageVo;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 17:35
 * @desc
 */
@Component
@Slf4j
public class InviteRelationFallbackFactory implements FallbackFactory<InviteRelationFeignService> {
    @Override
    public InviteRelationFeignService create(Throwable throwable) {
        return new InviteRelationFeignService() {
            @Override
            public ResponseEntity<Integer> addInviteRelation(Long userId, Long masterId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<Json> awakeAllPrentices(Long userId, String remoteAddr) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Json.build());
            }

            @Override
            public ResponseEntity<Integer> updateUserAwakenState(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(0);
            }

            @Override
            public ResponseEntity<Json<ShareMessageVo>> getShareMessage(Long userId, Byte shareType) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Json.build(new ShareMessageVo()));
            }

            @Override
            public ResponseEntity<Json<ApprenticeInfoVo>> getApprenticeInfo(Long userId, Byte type) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Json.build(new ApprenticeInfoVo()));
            }
        };
    }
}
