package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.RecommendFeignService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class RecommendFallbackFactory implements FallbackFactory<RecommendFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(RecommendFallbackFactory.class);

    @Override
    public RecommendFeignService create(Throwable throwable) {
        return new RecommendFeignService() {
            @Override
            public ResponseEntity cleanMixRecommendCache(Long userId) {
                //记录请求参数
                LOGGER.error("cleanMixRecommendCache:userId:{}", userId);
                //记录错误消息
                LOGGER.error(throwable.getMessage(), throwable);
                return null;
            }

        };
    }
}
