package com.bxm.localnews.user.facade.fallback;

import java.math.BigDecimal;

import com.bxm.localnews.user.facade.WithdrawFeignService;
import com.bxm.newidea.component.vo.Message;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/5/29 15:58
 * @desc
 */
@Component
@Slf4j
public class WithdrawFallbackFactory implements FallbackFactory<WithdrawFeignService> {

    @Override
    public WithdrawFeignService create(Throwable throwable) {
        return new WithdrawFeignService() {
            @Override
            public ResponseEntity<Message> appletWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Message.build(false));
            }
        };
    }
}
