package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.dto.LocationDetailDTO;
import com.bxm.localnews.user.facade.LocationFeignService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/3/1 14:00
 * @desc
 */
@Service
public class LocationIntegrationService {

    @Autowired
    private LocationFeignService locationFeignService;

    public LocationDTO getLocationByCode(String code) {
        return locationFeignService.getLocationByCode(code).getBody();
    }

    public LocationDetailDTO getLocationDetailByCode(String code) {
        return locationFeignService.getLocationDetailByCode(code).getBody();
    }

    public LocationDTO getLocationByGeocode(String code) {
        return locationFeignService.getLocationByGeocode(code).getBody();
    }
}
