package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.facade.RecommendFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 新闻推荐调用接口封装
 * @author liujia
 */
@Service
public class RecommendIntegrationService {

    private final RecommendFeignService recommendFeignService;

    @Autowired
    public RecommendIntegrationService(RecommendFeignService recommendFeignService) {
        this.recommendFeignService = recommendFeignService;
    }

    public void cleanMixRecommendCache(Long userId) {
        recommendFeignService.cleanMixRecommendCache(userId);
    }

}
