/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.integration.MessageIntegrationService;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.service.BaseService;
import java.nio.charset.Charset;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriUtils;

@Service
public class MessageUserIntegrationService
extends BaseService {
    @Resource
    private MessageIntegrationService messageIntegrationService;
    @Resource
    private MessageSender messageSender;
    @Resource
    private DomainIntegrationService domainIntegrationService;

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);
        this.messageSender.sendUserMessage(pushMessage);
    }

    public Long getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {
        Map map = this.messageIntegrationService.getUnreadMap(userId, messageType);
        return (Long)map.get(messageType.name());
    }

    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("\u65b0\u589e\u7c89\u4e1d");
        pushMessage.setContent("\u7c89\u4e1d+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());
        this.addMessage(pushMessage, userId);
    }

    public void addGoldMsg(GoldFlow goldFlow, Integer usableGold) {
        String reason = StringUtils.isNotBlank((CharSequence)goldFlow.getContent()) ? goldFlow.getContent() : goldFlow.getRemark();
        String title = goldFlow.getAmount() > 0 ? "\u8d26\u6237\u4f59\u989d\u56e0" + reason + "\u589e\u52a0" + Math.abs(goldFlow.getAmount()) + "\u6735\u82b1\uff0c\u76ee\u524d\u5171\u6709" + usableGold + "\u6735\u5c0f\u7ea2\u82b1\u5566\uff01" : "\u8d26\u6237\u4f59\u989d\u56e0" + reason + "\u6263\u9664" + Math.abs(goldFlow.getAmount()) + "\u6735\u82b1\uff0c\u76ee\u524d\u5269\u4f59 " + usableGold + "\u6735\u5c0f\u7ea2\u82b1";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        info.setProtocol(this.genPointUrlProtocol(goldFlow.getUserId()));
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5\u6d88\u606f");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        message.assign(goldFlow.getUserId());
        this.addMessage(message, goldFlow.getUserId());
    }

    private String genPointUrlProtocol(Long userId) {
        String pointUrl = this.domainIntegrationService.getServerHostBaseUrl() + "/api/public/points/url?userId=" + userId;
        return "wst://web/webDetail?isFlowerStore=1&url=" + UriUtils.encode((String)pointUrl, (Charset)Charset.defaultCharset());
    }
}

