/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.dto.TopicFacadeVO;
import com.bxm.localnews.user.facade.ForumPostFacadeService;
import com.bxm.localnews.user.facade.NewsFacadeService;
import com.bxm.localnews.user.vo.RecommendUserFacadeVo;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class NewsIntegrationService {
    private static final Logger log = LogManager.getLogger(NewsIntegrationService.class);
    private final ForumPostFacadeService forumPostFacadeService;
    private final NewsFacadeService newsFacadeService;

    @Autowired
    public NewsIntegrationService(ForumPostFacadeService forumPostFacadeService, NewsFacadeService newsFacadeService) {
        this.forumPostFacadeService = forumPostFacadeService;
        this.newsFacadeService = newsFacadeService;
    }

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ResponseEntity<ForumPostBriefInfoDto> postWithoutDetail = this.forumPostFacadeService.getPostWithoutDetail(postId);
        if (postWithoutDetail.hasBody()) {
            return (ForumPostBriefInfoDto)postWithoutDetail.getBody();
        }
        return ForumPostBriefInfoDto.builder().id(postId).build();
    }

    public NewsBriefInfoDto getNewsInfo(Long newsId) {
        ResponseEntity<NewsBriefInfoDto> newsInfo = this.newsFacadeService.getBriefInfo(newsId, null, null);
        if (newsInfo.hasBody()) {
            return (NewsBriefInfoDto)newsInfo.getBody();
        }
        return NewsBriefInfoDto.builder().id(newsId).build();
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        ResponseEntity<TopicFacadeVO> topic = this.forumPostFacadeService.getTopicById(topicId);
        if (topic.hasBody()) {
            return (TopicFacadeVO)topic.getBody();
        }
        return TopicFacadeVO.builder().id(topicId).build();
    }

    public List<RecommendUserFacadeVo> getRecommendUserList(String areaCode, List<Long> userIds) {
        try {
            ResponseEntity<List<RecommendUserFacadeVo>> entity = this.forumPostFacadeService.getRecommendUserInfo(areaCode, userIds);
            if (entity.hasBody()) {
                return (List)entity.getBody();
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u5f02\u5e38 \uff1a {}", (Throwable)e);
        }
        return new ArrayList<RecommendUserFacadeVo>();
    }
}

