package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class EquipmentDTO {

    @ApiModelProperty("服务端的设备唯一标识，客户端在第一次上报时，id为空，在上报完毕得到id后将其缓存至本地，下次上报携带id进行更新(在基础参数中作为devcId)")
    private String id;

    @ApiModelProperty("android:表示唯一值，不同手机返回不同（ DEVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取。")
    private String IMEI;

    @ApiModelProperty("android：安卓系统初始化时创建一次，重置系统会被重置")
    private String androidId;

    @ApiModelProperty("android：每次即生成的uuid")
    private String androidUuid;

    @ApiModelProperty("ios：中的 广告追踪 ID ， 用户可进行重置或阻止追踪 （返回 16 个 0 ）")
    private String IDFA;

    @ApiModelProperty("ios：本文档中特指 iOS 设备号，由 App 创建后上传，可保证同一设备同一 App 重复安装仍保持一致")
    private String iosId;

    @ApiModelProperty("是否开启消息通知 否:false")
    private boolean enableNotification;

    @ApiModelProperty("手机型号")
    private String phoneModel;

    @ApiModelProperty("操作系统版本")
    private String operatingSystem;

    @ApiModelProperty(value = "通用参数：当前APP的上线版本", required = true)
    private String curVer;

}
