package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.CommodityGoodsDTO;
import com.bxm.localnews.user.facade.fallback.CommodityFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;

@Api(tags = "4-53 [内部]商品信息服务")
@FeignClient(value = "fossicker-commodity", fallbackFactory = CommodityFallbackFactory.class, primary = false)
public interface CommodityFeignService {

    @ApiOperation("4-53-06 [内部]获取商品简略信息")
    @RequestMapping("/facade/commodity/info/simple")
    ResponseEntity<CommodityGoodsDTO> getBriefGoodsById(String goodsId);
}
