package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.dto.TopicFacadeVO;
import com.bxm.localnews.user.facade.fallback.ForumPostFallbackFactory;
import com.bxm.localnews.user.vo.ForumPostVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 新闻服务的帖子对外接口
 * @author liujia
 * @date 2020/05/12 10:49
 */
@Api(tags = "4-95 [内部]帖子接口")
@RequestMapping("facade/forumPost")
@FeignClient(value = "localnews-news", fallbackFactory = ForumPostFallbackFactory.class, primary = false)
public interface ForumPostFacadeService {

    @ApiOperation(value = "4-95-10 根据id获取话题信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "话题ID", required = true),
    })
    @GetMapping(value = "getTopicById")
    ResponseEntity<TopicFacadeVO> getTopicById(Long id);

    @ApiOperation(value = "4-95-11 获取帖子简略信息,不走详情查询（太重了）")
    @ApiImplicitParam(name = "postId", value = "帖子ID", required = true)
    @GetMapping("lightweight")
    ResponseEntity<ForumPostBriefInfoDto> getPostWithoutDetail(@RequestParam("postId") Long postId);

    @ApiOperation(value = "4-95-12 根据id获取话题信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子ID", required = true),
    })
    @GetMapping(value = "getForumPostById")
    ResponseEntity<ForumPostVo> getForumPostById(@RequestParam("id") Long id);

}
