package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.facade.fallback.ImFallbackFactory;
import com.bxm.localnews.user.vo.ImChatroom;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-im", fallbackFactory = ImFallbackFactory.class, primary = false)
@RequestMapping("facade/im")
public interface IMFacadeService {

    @ApiOperation(value = "7-99-7 获取地区聊天室信息", notes = "根据地区编码获取聊天室信息")
    @GetMapping("area/chatroom")
    ResponseEntity<ImChatroom> getChatRoom(@RequestParam("areaCode") String areaCode);

    @ApiOperation(value = "7-99-13 用户信息变更，同步更新")
    @PostMapping("/sync")
    ResponseEntity<Boolean> syncUser(@RequestParam("userId") Long userId);
}
