package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.facade.fallback.WithdrawFallbackFactory;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

@FeignClient(value = "localnews", fallbackFactory = WithdrawFallbackFactory.class, primary = false)
public interface WithdrawFeignService {

    @PostMapping("/facade/withdraw/manage/applet")
    ResponseEntity<Message> appletWithdraw(@RequestParam("userId") Long userId,
                                           @RequestParam("openId") String openId,
                                           @RequestParam("amount") BigDecimal amount,
                                           @RequestParam("devcId") String devcId,
                                           @RequestParam("ip") String ip);

    @ApiOperation(value = "6-90-4 获取提现配置", notes = "兼容历史接口，从用户模块迁移的配置信息")
    @GetMapping("/facade/withdraw/manage/config/withdraw")
    ResponseEntity<WithdrawDTO> getWithdrawDto(@RequestParam("userId") Long userId);
}
