package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.facade.AdvertFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class AdvertFallbackFactory implements FallbackFactory<AdvertFeignService> {

    @Override
    public AdvertFeignService create(Throwable throwable) {
        return androidId -> {
            log.error(throwable.getMessage(),throwable);
            return ResponseEntity.ok(Boolean.FALSE);
        };
    }
}

