package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.NewsMissionRewardDTO;
import com.bxm.localnews.user.facade.MissionFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/1 14:23
 * @desc
 */
@Component
@Slf4j
public class MissionFallbackFactory implements FallbackFactory<MissionFeignService> {

    @Override
    public MissionFeignService create(Throwable throwable) {
        return new MissionFeignService() {
            @Override
            public ResponseEntity<NewsMissionRewardDTO> completeTask(Long userId, String taskName, String relationId) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new NewsMissionRewardDTO());
            }
        };
    }
}
