package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.facade.IMFacadeService;
import com.bxm.localnews.user.vo.ImChatroom;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.base.Preconditions;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class IMIntegrationService {
    @Resource
    private IMFacadeService imFacadeService;

    /**
     * 获取地区编码对应开通的聊天室
     * @param areaCode 地区编码
     * @return 如果地区未开通聊天室，返回null
     */
    public ImChatroom getChatRoom(String areaCode) {
        if (StringUtils.isBlank(areaCode)) {
            return null;
        }

        ResponseEntity<ImChatroom> responseEntity = imFacadeService.getChatRoom(areaCode);
        if (responseEntity.hasBody()) {
            return responseEntity.getBody();
        }
        return null;
    }

    public void syncUser(Long userId) {
        Preconditions.checkArgument(null != userId);
        imFacadeService.syncUser(userId);
    }
}
