package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.MerchantUserDTO;
import com.bxm.localnews.user.facade.MerchantFeignService;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Author: pf.w
 * @Date: 2020/7/16 12:08
 */
@Service
public class MerchantIntegrationService {

    @Resource
    MerchantFeignService merchantFeignService;

    public MerchantUserDTO getUserMerchantInfo(Long userId){
        ResponseEntity<MerchantUserDTO> entity = merchantFeignService.userMerchantInfo(userId);

        if(entity.hasBody()){
            return entity.getBody();
        }else{
            return new MerchantUserDTO();
        }
    }
}
