package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.NewsMissionRewardDTO;
import com.bxm.localnews.user.enums.TaskEnum;
import com.bxm.localnews.user.facade.MissionFeignService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * Created by Administrator on 2018/2/23.
 */
@Service
@Slf4j
public class MissionIntegrationService {

    @Resource
    private MissionFeignService missionFeignService;

    /**
     * 完成任务，同步
     * @param userId
     * @param taskTypeEnum
     * @param relationId
     */
    public NewsMissionRewardDTO completeTask(Long userId, TaskEnum taskTypeEnum, String relationId) {
        log.debug("用户[{}]远程完成任务调用接口", userId);
        ResponseEntity<NewsMissionRewardDTO> newsMissionRewardDtoResponseEntity=  missionFeignService.completeTask(userId, taskTypeEnum.name(), relationId);
        return newsMissionRewardDtoResponseEntity.getBody();
    }

    /**
     * 完成任务，异步
     * @param userId
     * @param taskTypeEnum
     * @param relationId
     */
    @Async
    public void asyncCompleteTask(Long userId, TaskEnum taskTypeEnum, String relationId) {
        log.debug("用户[{}]远程完成任务调用接口", userId);
        missionFeignService.completeTask(userId, taskTypeEnum.name(), relationId).getBody();
    }
}
