package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.dto.TopicFacadeVO;
import com.bxm.localnews.user.facade.ForumPostFacadeService;
import com.bxm.localnews.user.facade.NewsFacadeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * 新闻服务集成服务接口
 * @author liujia
 * @date 2020/05/12 10:55
 */
@Component
public class NewsIntegrationService {
    private final ForumPostFacadeService forumPostFacadeService;

    private final NewsFacadeService newsFacadeService;

    @Autowired
    public NewsIntegrationService(ForumPostFacadeService forumPostFacadeService,
                                  NewsFacadeService newsFacadeService) {
        this.forumPostFacadeService = forumPostFacadeService;
        this.newsFacadeService = newsFacadeService;
    }

    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {
        ResponseEntity<ForumPostBriefInfoDto> postWithoutDetail = forumPostFacadeService.getPostWithoutDetail(postId);
        if (postWithoutDetail.hasBody()) {
            return postWithoutDetail.getBody();
        }
        return ForumPostBriefInfoDto.builder().id(postId).build();
    }

    public NewsBriefInfoDto getNewsInfo(Long newsId) {
        ResponseEntity<NewsBriefInfoDto> newsInfo = newsFacadeService.getBriefInfo(newsId, null, null);
        if (newsInfo.hasBody()) {
            return newsInfo.getBody();
        }
        return NewsBriefInfoDto.builder().id(newsId).build();
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        ResponseEntity<TopicFacadeVO> topic = forumPostFacadeService.getTopicById(topicId);
        if (topic.hasBody()) {
            return topic.getBody();
        }
        return TopicFacadeVO.builder().id(topicId).build();
    }
}
