package com.bxm.localnews.user.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.properties.CommonProperties;
import com.bxm.localnews.user.vo.ImChatroom;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * 消息推送集成服务
 *
 * @author zhaoyadong 2019/3/14 15:58
 */
@Service
public class PushMsgIntegrationService extends BaseService {

    @Resource
    private IMIntegrationService imIntegrationService;

    @Resource
    private CommonProperties commonProperties;

    @Resource
    private MessageSender messageSender;


    /**
     * 推送金额变化
     */
    public void pushChangeAccountMsg(AccountCashParam param) {
        String title = "\uD83D\uDCB0" + "钱包到账" + param.getCash().setScale(2, BigDecimal.ROUND_HALF_UP) + "元";
        if (StringUtils.isNotBlank(param.getInviteType()) && StringUtils.isNotBlank(param.getInvitedUserName())) {
            title += "，" + param.getInvitedUserName() + "通过您转发的【" + InviteTypeEnum.valueOf(param.getInviteType()).getDesc()
                    + "】注册了本地万事通。经常转发，惊喜更多哦~";
        }

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.ADD_CASH);

        PushMessage message = PushMessage.build();
        message.setTitle("通知");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(param.getUserId()));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);

        messageSender.sendPushMessage(message);
    }

    /**
     * 推送邀请通知
     */
    public void pushInviteMsg(Long userId, String headImg, String nickName, Integer gold, Integer userType) {
        if (null == userType) {
            return;
        }

        String action;
        if (0 == userType) {
            action = "收到了你的邀请，加入本地万事通小程序，奖励你" + gold + "朵小红花";
        } else {
            action = "收到了你的邀请，再次回到了本地万事通小程序，奖励你" + gold + "朵小红花";
        }
        String title = nickName + action;

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.INVITE);
        Long msgId = nextId();
        info.setMsgId(msgId);
        //添加用户图标
        info.addExtend("msgId", msgId);
        info.addExtend("title", title);
        info.addExtend("icon", headImg);
        info.addExtend("nickname", nickName);
        info.addExtend("action", action);
        info.addExtend("userType", userType);
        info.addExtend("flowerNum", gold);

        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    /**
     * 推送邀请通知
     */
    public void sendSystemMessage(Long userId, int num, LocationUserInfoDTO location) {
        String url = "wst://mine/userHomePage?userId=" + userId;
        String copyWrite = "最近有" + num + "人查看了你的主页，看看都有谁。";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.addExtend("msgId", nextId());
        info.addExtend("url", url);
        info.setProtocol(buildProtocol(userId, location));

        PushMessage message = PushMessage.build();
        message.setTitle("通知");
        message.setContent(copyWrite);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    private String buildProtocol(Long userId, LocationUserInfoDTO location) {
        if (null == location) {
            return null;
        }

        String visitorHtml = commonProperties.getH5ServerHost() + "/" +
                "index.html#/visitor?userId=" + userId +
                "&areaCode=" + location.getLocationCode() +
                "&areaName=" + location.getLocationName();

        logger.debug("最近访问人数跳转访问地址：[{}]", visitorHtml);

        return visitorHtml;
    }

    /**
     * 邀请关系建立成功后解锁邀请人的抢群聊红包的权限
     *
     * @param userId         用户ID
     * @param inviteUserName 被邀请人名称
     * @param location       邀请人所属地区信息
     */
    public void pushUnlockPickAuth(Long userId, String inviteUserName, LocationUserInfoDTO location) {
        //获取用户当前定位地区的聊天室信息
        ImChatroom chatRoom = imIntegrationService.getChatRoom(location.getLocationCode());

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.UNLOCK_PICK_REDPACKAGE);

        //如果目标聊天室不存在则跳转到消息中心
        if (null != chatRoom) {
            info.addExtend("chatRoomId", chatRoom.getChatRoomId());
            info.addExtend("areaCode", location.getLocationCode());
            info.addExtend("areaName", location.getLocationName());
        } else {
            info.addExtend("chatRoomId", StringUtils.EMPTY);
        }

        PushMessage message = PushMessage.build();
        message.setTitle("可以抢红包啦！");
        message.setContent("您已成功解锁聊天室抢红包权限，" + inviteUserName + "注册了App，快进入聊天室抢红包吧~");
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    /**
     * 师傅收到徒弟充值VIP后的奖励推送
     *
     * @param userId 师傅id(接收人id)
     * @param name   被邀请人昵称
     * @param money  收到的奖励金额
     */
    public void pushMasterReceiveAward(Long userId, String name, BigDecimal money) {
        if (StringUtils.isEmpty(name)) {
            name = "好友";
        }
        String protocol = "wst://mine/totalEarnings";
        String title = "您成功邀请好友开通万事通VIP";
        String content = name + "通过您的邀请开通了万事通vip卡，您获得" + money + "元现金奖励，快来提现吧";
        PushReceiveScope pushReceiveScope = PushReceiveScope.pushSignle(userId);
        pushReceiveScope.setPushReceiverRule(PushReceiverRuleEnum.DEFAULT);
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setPayloadInfo(info);
        message.setPushReceiveScope(pushReceiveScope);

        if (logger.isDebugEnabled()) {
            logger.debug("pushMasterReceiveAward发送推送：[{}]", JSONObject.toJSONString(message));
        }

        messageSender.sendPushMessage(message);
    }

    /**
     * 师傅收到徒弟邀请码激活VIP消息
     *
     * @param userId 师傅id(接收人id)，
     * @param name   被邀请人昵称
     */
    public void pushMasterReceiveMessage(Long userId, String name, LocationUserInfoDTO locationCode) {
        if (StringUtils.isEmpty(name)) {
            name = "好友";
        }
        String protocol = commonProperties.getH5ServerHost() + "/" +
                "tk/member.html#/app/apprentice/my?userId=" + userId +
                "&areaCode=" + locationCode.getLocationCode() +
                "&areaName=" + locationCode.getLocationName();

        String title = "您成功邀请好友开通万事通VIP";
        String content = name + "通过您的邀请码开通了万事通vip卡，快来看看吧";
        PushReceiveScope pushReceiveScope = PushReceiveScope.pushSignle(userId);
        pushReceiveScope.setPushReceiverRule(PushReceiverRuleEnum.DEFAULT);
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setPushReceiveScope(pushReceiveScope);
        message.setContent(content);
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    /**
     * 给用户推送收徒信息
     *
     * @param userId    接收消息的用户
     * @param inviteNum 用户昨日收徒数量
     */
    public void pushUserInvite(Long userId, Integer inviteNum, LocationUserInfoDTO location) {
        if (null == location) {
            return;
        }
        String protocol = commonProperties.getH5ServerHost() + "/" +
                "tk/member.html#/app/apprentice/my?userId=" + userId +
                "&areaCode=" + location.getLocationCode() +
                "&areaName=" + location.getLocationName();

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);

        PushMessage message = PushMessage.build();
        message.setTitle("收徒情况通知");
        message.setContent("你昨天收了" + inviteNum + "位徒弟，快去看看都是谁吧");
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }
}
