package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.WithdrawDTO;
import com.bxm.localnews.user.facade.WithdrawFeignService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

@Service
public class WithdrawIntegrationService {

    @Resource
    private WithdrawFeignService withdrawFeignService;

    public Message appletWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip) {
        return withdrawFeignService.appletWithdraw(userId, openId, amount, devcId, ip).getBody();
    }

    public WithdrawDTO getWithdrawDto(Long userId) {
        ResponseEntity<WithdrawDTO> withdrawDto = withdrawFeignService.getWithdrawDto(userId);
        if (withdrawDto.hasBody()) {
            return withdrawDto.getBody();
        }

        return new WithdrawDTO();
    }
}
