package com.bxm.localnews.user.facade;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.facade.fallback.AppVersionFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/2/28 17:49
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = AppVersionFallbackFactory.class, primary = false)
public interface AppVersionFeignService {

    @GetMapping("/facade/app/version/state")
    ResponseEntity<Boolean> getPublishState(@RequestBody BasicParam basicParam);

    @GetMapping("/facade/app/version/white")
    ResponseEntity<Boolean> inWhiteList(@RequestParam("phone") String phone);
}

