package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.EquipmentDTO;
import com.bxm.localnews.user.facade.fallback.BizFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 业务模块
 */
@FeignClient(value = "localnews", fallbackFactory = BizFallbackFactory.class, primary = false)
public interface BizFeignService {

    /**
     * 根据设备号获取设备信息
     * @param id 设备号可以是设备唯一标识，IMEI ,IDFA等标识
     */
    @GetMapping("/facade/device/get/{id}")
    ResponseEntity<EquipmentDTO> getDevice(@PathVariable("id") String id);

}
