package com.bxm.localnews.user.facade;

import com.bxm.localnews.common.param.PointReportParam;
import com.bxm.localnews.user.facade.fallback.BizLogFallbackFactory;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 业务日志记录服务接口
 */
@FeignClient(value = "localnews", fallbackFactory = BizLogFallbackFactory.class, primary = false )
public interface BizLogFeignService {

    @PostMapping("facade/biz/log/register")
    void newUser(@RequestParam("userId") Long userId, @RequestParam("channel") String channel,
                 @RequestParam("token") String token, @RequestParam("amount") BigDecimal amount,
                 @RequestParam("registerChannel") String registerChannel,
                 @RequestParam("rid") String rid, @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/login")
    void login(@RequestParam("userId") Long userId, @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/changeGender")
    void changeGender(@RequestParam("userId") Long userId, @RequestParam("sex") int sex,
                      @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/changeArea")
    void changeArea(@RequestParam("userId") Long userId, @RequestParam("areaCode") String areaCode,
                    @RequestParam(value = "platform", required = false) Integer platform);

    @PostMapping("facade/biz/log/inviteSuccessed")
    void inviteSuccessed(@RequestParam("userId") Long userId, @RequestParam("invitedUserId") Long invitedUserId,
                         @RequestParam(value = "platform", required = false) Integer platform);

    @ApiOperation(value = "1-100-11 通用日志埋点", notes = "参数为对应埋点需要的参数，包括事件值等.后续再有埋点需求，使用通用埋点， 不进行单独定义。埋点具体需要的参数，由调用服务的Integration进行封装")
    @PostMapping("/facade/biz/log/point")
    void point(@RequestBody PointReportParam param);
}
