package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.MerchantUserDTO;
import com.bxm.localnews.user.facade.fallback.MerchantFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: pf.w
 * @Date: 2020/7/16 12:02
 */
@FeignClient(value = "localnews-merchant", fallbackFactory = MerchantFallbackFactory.class,primary = false)
public interface MerchantFeignService {

    @GetMapping("/facade/merchant/userMerchant")
    ResponseEntity<MerchantUserDTO> userMerchantInfo(@RequestParam("userId") Long userId);
}
