package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.NewsMissionRewardDTO;
import com.bxm.localnews.user.facade.fallback.MissionFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhaoyadong 2019/3/1 14:22
 * @desc
 */
@FeignClient(value = "localnews", fallbackFactory = MissionFallbackFactory.class, primary = false)
public interface MissionFeignService {

    @PostMapping("facade/activity/mission/comple")
    ResponseEntity<NewsMissionRewardDTO> completeTask(@RequestParam("userId") Long userId, @RequestParam("taskName") String taskName,
                                                      @RequestParam(value = "relationId", required = false) String relationId);
}
