package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.NewsBriefInfoDto;
import com.bxm.localnews.user.facade.fallback.NewsFallbackFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 新闻服务 - 获取新闻相关的接口
 * @author liujia
 * @date 2020/05/12 11:22
 */
@Api(tags = "4-96 [内部]新闻相关接口")
@RequestMapping("facade/news")
@FeignClient(value = "localnews-news", fallbackFactory = NewsFallbackFactory.class, primary = false)
public interface NewsFacadeService {

    @ApiOperation(value = "4-96-1 获取新闻简略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "访问请求来源用户所属区域编码"),
            @ApiImplicitParam(name = "userId", value = "访问接口的用户ID")
    })
    @GetMapping("briefInfo")
    ResponseEntity<NewsBriefInfoDto> getBriefInfo(@RequestParam("newsId") Long newsId,
                                                  @RequestParam(value = "areaCode", required = false) String areaCode,
                                                  @RequestParam(value = "userId", required = false) Long userId);
}
