package com.bxm.localnews.user.facade;

import com.bxm.localnews.user.dto.NoteDTO;
import com.bxm.localnews.user.dto.UserImgDTO;
import com.bxm.localnews.user.facade.fallback.UserNewsFallbackFactory;
import com.bxm.localnews.user.vo.User;
import com.bxm.localnews.user.vo.UserLikeVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "localnews-news", fallbackFactory = UserNewsFallbackFactory.class, primary = false)
public interface UserNewsFeignService {

    @PostMapping("/facade/news/init")
    void initUserImage(@RequestParam("newUserId") Long newUserId, @RequestParam("defaultUserId") Long defaultUserId);

    @PostMapping("/facade/news/sync")
    void syncUser(@RequestBody User user);

    @PostMapping("/facade/forumPost/getPublishPostNum")
    Integer getPublishPostNum(@RequestParam("userId") Long userId);

    @PostMapping("/facade/news/getLikeNumByUserIds")
    ResponseEntity<List<UserLikeVo>> getLikeNumByUserIds(@RequestBody List<Long> userIds);

    @PostMapping("/facade/sensitive/verify")
    ResponseEntity<Boolean> verifySensitiveWord(@RequestBody String text);

    @GetMapping("/facade/forumPost/batchGetUserImg")
    ResponseEntity<List<UserImgDTO>> batchGetUserImg(@RequestParam(value = "userIdList") List<Long> userIdList,
                                                     @RequestParam(value = "currentUserId", required = false) Long currentUserId);

    @GetMapping("/facade/note/batchGetUserNote")
    ResponseEntity<List<NoteDTO>> batchGetUserNote(@RequestParam(value = "userIdList") List<Long> userIdList,
                                                   @RequestParam(value = "currentUserId", required = false) Long currentUserId);
}
