package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.MerchantUserDTO;
import com.bxm.localnews.user.facade.MerchantFeignService;
import feign.hystrix.FallbackFactory;
import lombok.extern.log4j.Log4j2;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @Author: pf.w
 * @Date: 2020/7/16 12:03
 */
@Component
@Log4j2
public class MerchantFallbackFactory implements FallbackFactory<MerchantFeignService> {
    @Override
    public MerchantFeignService create(Throwable throwable) {
        return new MerchantFeignService() {
            @Override
            public ResponseEntity<MerchantUserDTO> userMerchantInfo(Long userId) {

                log.error(throwable.getMessage(), throwable);
                return  ResponseEntity.ok(new MerchantUserDTO());
            }
        };
    }
}
