package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.SignWarper;
import com.bxm.localnews.user.facade.SignFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/3/1 13:39
 * @desc
 */
@Component
@Slf4j
public class SignFallbackFactory implements FallbackFactory<SignFeignService> {

    @Override
    public SignFeignService create(Throwable throwable) {
        return new SignFeignService() {
            @Override
            public ResponseEntity<SignWarper> listSignRecord(Long userId, int platform) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(new SignWarper());
            }
        };
    }
}
