package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.user.dto.NoteDTO;
import com.bxm.localnews.user.dto.UserImgDTO;
import com.bxm.localnews.user.facade.UserNewsFeignService;
import com.bxm.localnews.user.vo.User;

import com.bxm.localnews.user.vo.UserLikeVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
@Slf4j
public class UserNewsFallbackFactory implements FallbackFactory<UserNewsFeignService> {
    @Override
    public UserNewsFeignService create(Throwable throwable) {
        return new UserNewsFeignService() {
            @Override
            public void initUserImage(Long newUserId, Long defaultUserId) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public void syncUser(User user) {
                log.error(throwable.getMessage(), throwable);
            }

            @Override
            public Integer getPublishPostNum(Long userId) {
                log.error(throwable.getMessage(), throwable);
                return 0;
            }

            @Override
            public ResponseEntity<List<UserLikeVo>> getLikeNumByUserIds(List<Long> userId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<Boolean> verifySensitiveWord(String text) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<UserImgDTO>> batchGetUserImg(List<Long> userIdList,
                                                                    Long currentUserId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

            @Override
            public ResponseEntity<List<NoteDTO>> batchGetUserNote(List<Long> userIdList,
                                                                  Long currentUserId) {
                log.error(throwable.getMessage(), throwable);
                return null;
            }

        };
    }
}
