package com.bxm.localnews.user.integration;

import com.bxm.localnews.mq.common.constant.MessageTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.integration.MessageIntegrationService;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.vo.GoldFlow;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * @author zhaoyadong 2019/3/1 10:11
 * @desc
 */
@Service
public class MessageUserIntegrationService extends BaseService {

    @Resource
    private MessageIntegrationService messageIntegrationService;

    @Resource
    private MessageSender messageSender;

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);

        messageSender.sendUserMessage(pushMessage);
    }

    public Long getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {
        Map<String, Long> map = messageIntegrationService.getUnreadMap(userId, messageType);

        return map.get(messageType.name());
    }

    /**
     * 新增粉丝时，同步到消息服务，给用户个人消息中显示
     *
     * @param userId 对应的用户ID
     */
    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("新增粉丝");
        pushMessage.setContent("粉丝+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());

        addMessage(pushMessage, userId);
    }

    /**
     * 添加金币消息
     */
    public void addGoldMsg(GoldFlow goldFlow, Integer usableGold) {
        String reason;
        if (StringUtils.isNotBlank(goldFlow.getContent())) {
            reason = goldFlow.getContent();
        } else {
            reason = goldFlow.getRemark();
        }

        String title;
        if (goldFlow.getAmount() > 0) {
            title = "账户余额因" + reason + "增加" + Math.abs(goldFlow.getAmount())
                    + "朵花，目前共有" + usableGold + "朵小红花啦！";
        } else {
            title = "账户余额因" + reason + "扣除" + Math.abs(goldFlow.getAmount())
                    + "朵花，目前剩余 " + usableGold + "朵小红花";
        }

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.UPDATE_GOLD);
        info.setMsgId(nextId());
        info.addExtend("type", 1);
        PushMessage message = PushMessage.build();
        message.setTitle("通知消息");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(goldFlow.getUserId()));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        this.addMessage(message, goldFlow.getUserId());
    }
}
