/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.dto.LocationDTO;
import com.bxm.localnews.user.facade.LocationFeignService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService {
    @Resource
    private LocationFeignService locationFeignService;
    private LoadingCache<String, LocationDTO> cache;

    public LocationDTO getLocationByGeocode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new LocationDTO();
        }
        if (this.cache == null) {
            this.initCache();
        }
        return (LocationDTO)this.cache.getUnchecked((Object)code);
    }

    private void initCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).maximumSize(1000L).build((CacheLoader)new CacheLoader<String, LocationDTO>(){

            public LocationDTO load(String key) {
                LocationDTO body = (LocationDTO)LocationIntegrationService.this.locationFeignService.getLocationByGeocode(key).getBody();
                if (body == null) {
                    body = new LocationDTO();
                    body.setCode(key);
                }
                return body;
            }
        });
    }
}

