/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.base.integration.DomainIntegrationService;
import com.bxm.localnews.common.constant.InviteTypeEnum;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.PushReceiverRuleEnum;
import com.bxm.localnews.mq.common.constant.PushSoundEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.msg.sender.MessageSender;
import com.bxm.localnews.user.dto.LocationUserInfoDTO;
import com.bxm.localnews.user.integration.IMIntegrationService;
import com.bxm.localnews.user.param.AccountCashParam;
import com.bxm.localnews.user.vo.ImChatroom;
import com.bxm.newidea.component.service.BaseService;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PushMsgIntegrationService
extends BaseService {
    @Resource
    private IMIntegrationService imIntegrationService;
    @Resource
    private MessageSender messageSender;
    @Resource
    private DomainIntegrationService domainIntegrationService;

    public void pushChangeAccountMsg(AccountCashParam param) {
        String title = "\ud83d\udcb0\u94b1\u5305\u5230\u8d26" + param.getCash().setScale(2, 4) + "\u5143";
        if (StringUtils.isNotBlank((CharSequence)param.getInviteType()) && StringUtils.isNotBlank((CharSequence)param.getInvitedUserName())) {
            title = title + "\uff0c" + param.getInvitedUserName() + "\u901a\u8fc7\u60a8\u8f6c\u53d1\u7684\u3010" + InviteTypeEnum.valueOf((String)param.getInviteType()).getDesc() + "\u3011\u6ce8\u518c\u4e86\u672c\u5730\u4e07\u4e8b\u901a\u3002\u7ecf\u5e38\u8f6c\u53d1\uff0c\u60ca\u559c\u66f4\u591a\u54e6~";
        }
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.ADD_CASH);
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5");
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)param.getUserId()));
        message.setPayloadInfo(info);
        message.setSound(PushSoundEnum.GOLD_SOUND);
        this.messageSender.sendPushMessage(message);
    }

    public void pushInviteMsg(Long userId, String headImg, String nickName, Integer gold, Integer userType) {
        if (null == userType) {
            return;
        }
        String action = 0 == userType ? "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u52a0\u5165\u672c\u5730\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\uff0c\u5956\u52b1\u4f60" + gold + "\u6735\u5c0f\u7ea2\u82b1" : "\u6536\u5230\u4e86\u4f60\u7684\u9080\u8bf7\uff0c\u518d\u6b21\u56de\u5230\u4e86\u672c\u5730\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f\uff0c\u5956\u52b1\u4f60" + gold + "\u6735\u5c0f\u7ea2\u82b1";
        String title = nickName + action;
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.INVITE);
        Long msgId = this.nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("title", (Object)title);
        info.addExtend("icon", (Object)headImg);
        info.addExtend("nickname", (Object)nickName);
        info.addExtend("action", (Object)action);
        info.addExtend("userType", (Object)userType);
        info.addExtend("flowerNum", (Object)gold);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    public void sendSystemMessage(Long userId, int num, LocationUserInfoDTO location) {
        String url = "wst://mine/userHomePage?userId=" + userId;
        String copyWrite = "\u6700\u8fd1\u6709" + num + "\u4eba\u67e5\u770b\u4e86\u4f60\u7684\u4e3b\u9875\uff0c\u770b\u770b\u90fd\u6709\u8c01\u3002";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.addExtend("msgId", (Object)this.nextId());
        info.addExtend("url", (Object)url);
        info.setProtocol(this.buildProtocol(userId, location));
        PushMessage message = PushMessage.build();
        message.setTitle("\u901a\u77e5");
        message.setContent(copyWrite);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    private String buildProtocol(Long userId, LocationUserInfoDTO location) {
        if (null == location) {
            return null;
        }
        String visitorHtml = StringUtils.join((Object[])new Serializable[]{this.domainIntegrationService.getInnerH5BaseUrl(), "index.html#/visitor?userId=", userId, "&areaCode=", location.getLocationCode(), "&areaName=", location.getLocationName()});
        this.logger.debug("\u6700\u8fd1\u8bbf\u95ee\u4eba\u6570\u8df3\u8f6c\u8bbf\u95ee\u5730\u5740\uff1a[{}]", (Object)visitorHtml);
        return visitorHtml;
    }

    public void pushUnlockPickAuth(Long userId, String inviteUserName, LocationUserInfoDTO location) {
        ImChatroom chatRoom = this.imIntegrationService.getChatRoom(location.getLocationCode());
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.UNLOCK_PICK_REDPACKAGE);
        if (null != chatRoom) {
            info.addExtend("chatRoomId", (Object)chatRoom.getChatRoomId());
            info.addExtend("areaCode", (Object)location.getLocationCode());
            info.addExtend("areaName", (Object)location.getLocationName());
        } else {
            info.addExtend("chatRoomId", (Object)"");
        }
        PushMessage message = PushMessage.build();
        message.setTitle("\u53ef\u4ee5\u62a2\u7ea2\u5305\u5566\uff01");
        message.setContent("\u60a8\u5df2\u6210\u529f\u89e3\u9501\u804a\u5929\u5ba4\u62a2\u7ea2\u5305\u6743\u9650\uff0c" + inviteUserName + "\u6ce8\u518c\u4e86App\uff0c\u5feb\u8fdb\u5165\u804a\u5929\u5ba4\u62a2\u7ea2\u5305\u5427~");
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    public void pushMasterReceiveAward(Long userId, String name, BigDecimal money) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "\u597d\u53cb";
        }
        String protocol = "wst://mine/totalEarnings";
        String title = "\u60a8\u6210\u529f\u9080\u8bf7\u597d\u53cb\u5f00\u901a\u4e07\u4e8b\u901aVIP";
        String content = name + "\u901a\u8fc7\u60a8\u7684\u9080\u8bf7\u5f00\u901a\u4e86\u4e07\u4e8b\u901avip\u5361\uff0c\u60a8\u83b7\u5f97" + money + "\u5143\u73b0\u91d1\u5956\u52b1\uff0c\u5feb\u6765\u63d0\u73b0\u5427";
        PushReceiveScope pushReceiveScope = PushReceiveScope.pushSignle((Long)userId);
        pushReceiveScope.setPushReceiverRule(PushReceiverRuleEnum.DEFAULT);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(content);
        message.setPayloadInfo(info);
        message.setPushReceiveScope(pushReceiveScope);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("pushMasterReceiveAward\u53d1\u9001\u63a8\u9001\uff1a[{}]", (Object)JSONObject.toJSONString((Object)message));
        }
        this.messageSender.sendPushMessage(message);
    }

    public void pushMasterReceiveMessage(Long userId, String name, LocationUserInfoDTO locationCode) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "\u597d\u53cb";
        }
        String protocol = StringUtils.join((Object[])new Serializable[]{this.domainIntegrationService.getInnerH5BaseUrl(), "tk/member.html#/app/apprentice/my?userId=", userId, "&areaCode=", locationCode.getLocationCode(), "&areaName=", locationCode.getLocationName()});
        String title = "\u60a8\u6210\u529f\u9080\u8bf7\u597d\u53cb\u5f00\u901a\u4e07\u4e8b\u901aVIP";
        String content = name + "\u901a\u8fc7\u60a8\u7684\u9080\u8bf7\u7801\u5f00\u901a\u4e86\u4e07\u4e8b\u901avip\u5361\uff0c\u5feb\u6765\u770b\u770b\u5427";
        PushReceiveScope pushReceiveScope = PushReceiveScope.pushSignle((Long)userId);
        pushReceiveScope.setPushReceiverRule(PushReceiverRuleEnum.DEFAULT);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setPushReceiveScope(pushReceiveScope);
        message.setContent(content);
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }

    public void pushUserInvite(Long userId, Integer inviteNum, LocationUserInfoDTO location) {
        if (null == location) {
            return;
        }
        String protocol = this.domainIntegrationService.getInnerH5BaseUrl() + "/tk/member.html#/app/apprentice/my?userId=" + userId + "&areaCode=" + location.getLocationCode() + "&areaName=" + location.getLocationName();
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);
        PushMessage message = PushMessage.build();
        message.setTitle("\u6536\u5f92\u60c5\u51b5\u901a\u77e5");
        message.setContent("\u4f60\u6628\u5929\u6536\u4e86" + inviteNum + "\u4f4d\u5f92\u5f1f\uff0c\u5feb\u53bb\u770b\u770b\u90fd\u662f\u8c01\u5427");
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.messageSender.sendPushMessage(message);
    }
}

