package com.bxm.localnews.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(description = "签到信息封装")
public class SignDTO {

    @ApiModelProperty("累计签到天数")
    private long count;

    @ApiModelProperty("签到列表，包含连续八天的签到情况")
    private List<SignRecord> records;

    @ApiModelProperty("今日签到状态（true表示今日已签到）")
    private boolean todaySignState;

    @ApiModelProperty("是否已经自动进行了签到,true表示自动完成了签到，需要给与用户对应的提示")
    private boolean autoSign;

    @ApiModelProperty("签到图片路径(autoSign为true才有值)")
    private String signImg;

    @ApiModelProperty("签到分享图片路径(autoSign为true才有值)")
    private String signShareImg;

    public String getSignShareImg() {
        return this.signShareImg;
    }

    public void setSignShareImg(String signShareImg) {
        this.signShareImg = signShareImg;
    }

    public String getSignImg() {
        return this.signImg;
    }

    public void setSignImg(String signImg) {
        this.signImg = signImg;
    }

    public boolean isAutoSign() {
        return this.autoSign;
    }

    public void setAutoSign(boolean autoSign) {
        this.autoSign = autoSign;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public List<SignRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<SignRecord> records) {
        this.records = records;
    }

    public boolean isTodaySignState() {
        return this.todaySignState;
    }

    public void setTodaySignState(boolean todaySignState) {
        this.todaySignState = todaySignState;
    }

}
