package com.bxm.localnews.user.dto;

import java.math.BigDecimal;

public class UserRewardStatDTO {

    private Long id;

    private Long userId;

    private Long userAmountId;

    private BigDecimal totalTribute;

    private BigDecimal moneyReward;

    private BigDecimal readReward;

    private BigDecimal shareArtical;

    private BigDecimal showIncome;

    private BigDecimal articalReadByShare;

    private BigDecimal goldReward;

    private String statDate;

    public UserRewardStatDTO() {
    }

    private UserRewardStatDTO(Long userId, Long userAmountId) {
        this.userId = userId;
        this.userAmountId = userAmountId;
        this.statDate = this.statDate;
        this.totalTribute = BigDecimal.ZERO;
        this.moneyReward = BigDecimal.ZERO;
        this.readReward = BigDecimal.ZERO;
        this.shareArtical = BigDecimal.ZERO;
        this.showIncome = BigDecimal.ZERO;
        this.articalReadByShare = BigDecimal.ZERO;
    }

    public static UserRewardStatDTO initUserRewardStat(Long userId, Long userAmountId) {
        return new UserRewardStatDTO(userId, userAmountId);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserAmountId() {
        return this.userAmountId;
    }

    public void setUserAmountId(Long userAmountId) {
        this.userAmountId = userAmountId;
    }

    public BigDecimal getTotalTribute() {
        return this.totalTribute;
    }

    public void setTotalTribute(BigDecimal totalTribute) {
        this.totalTribute = totalTribute;
    }

    public BigDecimal getMoneyReward() {
        return this.moneyReward;
    }

    public void setMoneyReward(BigDecimal moneyReward) {
        this.moneyReward = moneyReward;
    }

    public BigDecimal getReadReward() {
        return this.readReward;
    }

    public void setReadReward(BigDecimal readReward) {
        this.readReward = readReward;
    }

    public BigDecimal getShareArtical() {
        return this.shareArtical;
    }

    public void setShareArtical(BigDecimal shareArtical) {
        this.shareArtical = shareArtical;
    }

    public BigDecimal getShowIncome() {
        return this.showIncome;
    }

    public void setShowIncome(BigDecimal showIncome) {
        this.showIncome = showIncome;
    }

    public BigDecimal getArticalReadByShare() {
        return this.articalReadByShare;
    }

    public void setArticalReadByShare(BigDecimal articalReadByShare) {
        this.articalReadByShare = articalReadByShare;
    }

    public String getStatDate() {
        return this.statDate;
    }

    public void setStatDate(String statDate) {
        this.statDate = statDate;
    }

    public BigDecimal getGoldReward() {
        return this.goldReward;
    }

    public void setGoldReward(BigDecimal goldReward) {
        this.goldReward = goldReward;
    }

}