package com.bxm.localnews.user.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
@ApiModel(description = "用户实体入参")
public class UserParam {

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("用户昵称 只能改一次")
    private String nickname;

    @ApiModelProperty("性别：0:保密；1:男 ;2:女")
    private Byte sex;

    @ApiModelProperty(hidden = true)
    private Byte state;

    @ApiModelProperty("生日(精确到日) 格式：yyyy-mm-dd")
    private Date birthday;

    @ApiModelProperty("地址")
    private String address;

    @ApiModelProperty("头像图片")
    private MultipartFile file;

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Byte getSex() {
        return sex;
    }

    public void setSex(Byte sex) {
        this.sex = sex;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public Date getBirthday() {
        return birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public MultipartFile getFile() {
        return file;
    }

    public void setFile(MultipartFile file) {
        this.file = file;
    }
}
