package com.bxm.localnews.user.vo;

/**
 * Created by Administrator on 2018/3/2.
 */

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 我的零钱
 */
@ApiModel(description = "我的零钱")
public class CoinInfoModel {

    @ApiModelProperty("总零钱")
    private BigDecimal totalCoin;

    @ApiModelProperty("昨日零钱")
    private BigDecimal coinYesterday;

    /**
     * 金币兑换费率
     */
    @ApiModelProperty("金币兑换费率")
    private String transformRate;

    private List<FlowDetail> coinFlows = new ArrayList<>();

    public CoinInfoModel(BigDecimal totalCoin, BigDecimal coinYesterday, String transformRate, List<FlowDetail> coinFlows) {
        this.totalCoin = totalCoin == null ? BigDecimal.ZERO : totalCoin;
        this.coinYesterday = coinYesterday == null ? BigDecimal.ZERO : coinYesterday;
        this.transformRate = transformRate;
        this.coinFlows = coinFlows;
    }

    public BigDecimal getTotalCoin() {
        return this.totalCoin;
    }

    public void setTotalCoin(BigDecimal totalCoin) {
        this.totalCoin = totalCoin;
    }

    public BigDecimal getCoinYesterday() {
        return this.coinYesterday;
    }

    public void setCoinYesterday(BigDecimal coinYesterday) {
        this.coinYesterday = coinYesterday;
    }

    public String getTransformRate() {
        return this.transformRate;
    }

    public void setTransformRate(String transformRate) {
        this.transformRate = transformRate;
    }

    public List<FlowDetail> getCoinFlows() {
        return this.coinFlows;
    }

    public void setCoinFlows(List<FlowDetail> coinFlows) {
        this.coinFlows = coinFlows;
    }

}
