package com.bxm.localnews.user.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 我的金币
 * Created by Administrator on 2018/3/2.
 */

@ApiModel(description = "我的金币")
public class GoldInfoModel {

    @ApiModelProperty("总金币")
    private BigDecimal totalGold;

    @ApiModelProperty("昨日金币")
    private BigDecimal goldYesterday;

    @ApiModelProperty("金币流水详情")
    private List<FlowDetail> goldFlows = new ArrayList<>();

    public GoldInfoModel(BigDecimal totalGold, BigDecimal goldYesterday, List<FlowDetail> goldFlows) {
        this.totalGold = totalGold == null ? BigDecimal.ZERO : totalGold;
        this.goldYesterday = goldYesterday == null ? BigDecimal.ZERO : goldYesterday;
        this.goldFlows = goldFlows;
    }

    public BigDecimal getTotalGold() {
        return this.totalGold;
    }

    public void setTotalGold(BigDecimal totalGold) {
        this.totalGold = totalGold;
    }

    public BigDecimal getGoldYesterday() {
        return this.goldYesterday;
    }

    public void setGoldYesterday(BigDecimal goldYesterday) {
        this.goldYesterday = goldYesterday;
    }

    public List<FlowDetail> getGoldFlows() {
        return this.goldFlows;
    }

    public void setGoldFlows(List<FlowDetail> goldFlows) {
        this.goldFlows = goldFlows;
    }

}
