package com.bxm.localnews.user.vo;

import com.bxm.newidea.component.tools.StringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ApiModel(description = "徒弟详情")
public class PrenticeStatModel {

    @ApiModelProperty("徒弟累计进贡")
    private BigDecimal accumulateGold;

    @ApiModelProperty("昨日进贡")
    private BigDecimal goldYesterday;

    @ApiModelProperty("今日进贡")
    private BigDecimal goldToday;

    @ApiModelProperty(value = "累计徒孙奖励零钱", hidden = true)
    private BigDecimal accumulateCoin;

    @ApiModelProperty(value = "昨日徒孙累计奖励零钱", hidden = true)
    private BigDecimal coinYesterday;

    @ApiModelProperty(value = "今日徒孙累计奖励零钱", hidden = true)
    private BigDecimal coinToday;

    @ApiModelProperty("用户师父信息")
    private Master master;

    @ApiModelProperty("用户徒弟信息")
    private List<Prentice> prenticeList = new ArrayList<>();

    @ApiModelProperty(value = "用户徒孙信息", hidden = true)
    private List<Disciple> discipleList = new ArrayList<>();

    public void addAccumulateGold(BigDecimal accumulateGold) {
        this.accumulateGold = this.getAccumulateGold().add(accumulateGold);
    }

    public void addAccumulateCoin(BigDecimal accumulateCoin) {
        this.accumulateCoin = this.getAccumulateCoin().add(accumulateCoin);
    }

    public void addGoldToday(BigDecimal goldToday) {
        this.goldToday = this.getGoldToday().add(goldToday);
    }

    public void addCoinToday(BigDecimal coinToday) {
        this.coinToday = this.getCoinToday().add(coinToday);
    }

    public BigDecimal getAccumulateGold() {
        return this.accumulateGold;
    }

    public void setAccumulateGold(BigDecimal accumulateGold) {
        this.accumulateGold = accumulateGold;
    }

    public BigDecimal getGoldYesterday() {
        return this.goldYesterday;
    }

    public void setGoldYesterday(BigDecimal goldYesterday) {
        this.goldYesterday = goldYesterday;
    }

    public BigDecimal getGoldToday() {
        return this.goldToday;
    }

    public void setGoldToday(BigDecimal goldToday) {
        this.goldToday = goldToday;
    }

    public BigDecimal getAccumulateCoin() {
        if (null != this.accumulateCoin) {
            return this.accumulateCoin.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return this.accumulateCoin;
    }

    public void setAccumulateCoin(BigDecimal accumulateCoin) {
        this.accumulateCoin = accumulateCoin;
    }

    public BigDecimal getCoinYesterday() {
        if (null != this.coinYesterday) {
            return this.coinYesterday.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return this.coinYesterday;
    }

    public void setCoinYesterday(BigDecimal coinYesterday) {
        this.coinYesterday = coinYesterday;
    }

    public BigDecimal getCoinToday() {
        if (null != this.coinToday) {
            return this.coinToday.setScale(2, BigDecimal.ROUND_HALF_UP);
        }
        return this.coinToday;
    }

    public void setCoinToday(BigDecimal coinToday) {
        this.coinToday = coinToday;
    }

    public Master getMaster() {
        return this.master;
    }

    public void setMaster(Master master) {
        this.master = master;
    }

    public List<Prentice> getPrenticeList() {
        return this.prenticeList;
    }

    public void setPrenticeList(List<Prentice> prenticeList) {
        this.prenticeList = prenticeList;
    }

    public List<Disciple> getDiscipleList() {
        return this.discipleList;
    }

    public void setDiscipleList(List<Disciple> discipleList) {
        this.discipleList = discipleList;
    }

    public static class BaseInfo {

        private Long id;

        private String headImg;

        private String name;

        private String phone;

        private String nick;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getHeadImg() {
            return this.headImg;
        }

        public void setHeadImg(String headImg) {
            this.headImg = headImg;
        }

        public String getName() {
            return StringUtils.isNotBlank(this.nick) ? this.nick : (StringUtils.isNotBlank(this.name) ? this.name : this.getPhone());
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getNick() {
            return this.nick;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }

    }

    /**
     * 师父
     */
    public static class Master extends BaseInfo {

        private BigDecimal accumulateData;

        public String getNameStr() {
            return StringUtils.isBlank(this.getName()) ? StringUtils.hideMobile(this.getPhone()) : this.getName();
        }

        public void addAccumulateData(BigDecimal accumulateData) {
            this.accumulateData = this.getAccumulateData().add(accumulateData);
        }

        public BigDecimal getAccumulateData() {
            return this.accumulateData;
        }

        public void setAccumulateData(BigDecimal accumulateData) {
            this.accumulateData = accumulateData;
        }

    }

    @ApiModel(description = "徒弟信息")
    public static class Prentice extends BaseInfo {

        private BigDecimal todayData;

        private String state;

        public void addTodayData(BigDecimal todayData) {
            this.todayData = this.getTodayData().add(todayData);
        }

        public BigDecimal getTodayData() {
            return this.todayData;
        }

        public void setTodayData(BigDecimal todayData) {
            this.todayData = todayData;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

    }

    /**
     * 徒孙
     */
    public static class Disciple extends BaseInfo {

        private BigDecimal userCoin;

        public void addUserCoin(BigDecimal userCoin) {
            this.userCoin = this.getUserCoin().add(userCoin);
        }

        public BigDecimal getUserCoin() {
            return this.userCoin;
        }

        public void setUserCoin(BigDecimal userCoin) {
            this.userCoin = userCoin;
        }

    }

}
