package com.bxm.localnews.user.vo;

import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;

/**
 * 红包拉新活动等级奖励配置信息
 * @author liujia 2018/8/14 11:54
 */
public class RedPacketLevelConfig {

    private int count;

    private int gold;

    public RedPacketLevelConfig(String level) {
        String[] levelpart = StringUtils.split(level, ":");
        this.count = NumberUtils.parseToInt(levelpart[0]);
        this.gold = NumberUtils.parseToInt(levelpart[1]);
    }

    /**
     * 匹配是否发放奖励
     * @param currentCount 当前邀请总数
     * @param rewardCount  曾经发放奖励的最高总数
     * @return
     */
    public boolean match(int currentCount, int rewardCount) {
        return this.count <= currentCount && this.count > rewardCount;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getGold() {
        return this.gold;
    }

    public void setGold(int gold) {
        this.gold = gold;
    }

}
