package com.bxm.localnews.user.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(description = "注册用户传参实体,情景：[端内手机号注册][端内第三方绑定注册][h5站外微信第三方授权注册]")
public class RegisterParam extends SilentRegisterParam{

    /**
     * 有安卓端，ios端，h5前端三方面的注册，都通用这个类
     * 安卓端：1.手机号注册 2.第三方绑定注册
     * IOS端：1.手机号注册 2.第三方绑定注册
     * H5：1.手机号注册 2.第三方绑定注册
     */

    @ApiModelProperty("用户ID，同时也是用户的邀请码。如果是注册绑定则传递静默注册用户ID 有则必传")
    private Long id;

    @ApiModelProperty("登录标识,如果是[端内手机号注册]则传递手机号码，如果是[端内第三方绑定注册][h5站外微信第三方授权注册]则传递第三方登录标识(unionId) 必传")
    private String loginName;

    @ApiModelProperty("登录类型,1:手机号、密码登录，2：QQ登录，3：微信登录，4：微博登录 必传")
    private Byte type;

    @ApiModelProperty("用户手机号码，[端内手机号注册][端内第三方绑定注册][h5站外微信第三方授权注册]必传")
    private String phone;

    @ApiModelProperty("手机验证码，[端内手机号注册][端内第三方绑定注册][h5站外微信第三方授权注册]必传")
    private String code;

    @ApiModelProperty("登录密码，[端内手机号注册][端内第三方绑定注册][h5站外微信第三方授权注册]必传")
    private String password;

    @ApiModelProperty("用户头像路径，[端内第三方绑定注册][h5站外微信第三方授权注册]非必要")
    private String headImg;

    @ApiModelProperty("用户昵称，[端内第三方绑定注册][h5站外微信第三方授权注册]非必要")
    private String nickname;

    @ApiModelProperty("微信的openId，[端内第三方绑定注册][h5站外微信第三方授权注册]必传")
    private String openId;

    @ApiModelProperty("邀请码 非必要")
    private Long inviteCode;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHeadImg() {
        return headImg;
    }

    public void setHeadImg(String headImg) {
        this.headImg = headImg;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public Long getInviteCode() {
        return inviteCode;
    }

    public void setInviteCode(Long inviteCode) {
        this.inviteCode = inviteCode;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }
}
