package com.bxm.localnews.user.vo;

import com.bxm.localnews.common.constant.AppConst;

import java.math.BigDecimal;
import java.util.Date;

public class UserAmount {

    private Long id;

    private Long userId;

    private Byte state;

    private BigDecimal jbBalance;

    private BigDecimal totalJbBalance;

    private BigDecimal rmbBalance;

    private BigDecimal totalRmbBalance;

    private Date udpateTime;

    public UserAmount() {

    }

    //初始用户资金账户
    public UserAmount(Long userId) {
        this.userId = userId;
        this.state = AppConst.STATE_USE;
        BigDecimal bd = new BigDecimal(0);
        this.jbBalance = bd;
        this.totalJbBalance = bd;
        this.rmbBalance = bd;
        this.totalRmbBalance = bd;
    }

    public void addBalanceForJb(BigDecimal jbBalance) {
        this.jbBalance = this.getJbBalance().add(jbBalance);
        this.totalJbBalance = this.getTotalJbBalance().add(jbBalance);
    }

    public void addBalanceForRmb(BigDecimal rmbBalance) {
        this.rmbBalance = this.getRmbBalance().add(rmbBalance);
        this.totalRmbBalance = this.getTotalRmbBalance().add(rmbBalance);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Byte getState() {
        return this.state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public BigDecimal getJbBalance() {
        return this.jbBalance;
    }

    public void setJbBalance(BigDecimal jbBalance) {
        this.jbBalance = jbBalance;
    }

    public BigDecimal getTotalJbBalance() {
        return this.totalJbBalance;
    }

    public void setTotalJbBalance(BigDecimal totalJbBalance) {
        this.totalJbBalance = totalJbBalance;
    }

    public BigDecimal getRmbBalance() {
        return this.rmbBalance;
    }

    public void setRmbBalance(BigDecimal rmbBalance) {
        this.rmbBalance = rmbBalance;
    }

    public BigDecimal getTotalRmbBalance() {
        return this.totalRmbBalance;
    }

    public void setTotalRmbBalance(BigDecimal totalRmbBalance) {
        this.totalRmbBalance = totalRmbBalance;
    }

    public Date getUdpateTime() {
        return this.udpateTime;
    }

    public void setUdpateTime(Date udpateTime) {
        this.udpateTime = udpateTime;
    }

}